/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.integrations;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.core.impl.screen.ScreenConstants;
import com.gitlab.cdagaming.unilib.utils.GameUtils;
import com.gitlab.cdagaming.unilib.utils.WorldUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ScrollPane;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class ExtendedScreen
extends class_437
implements class_6379 {
    private static final int DEFAULT_ELEMENT_PADDING = 5;
    private static final int DEFAULT_ELEMENT_HEIGHT = 20;
    private static int lastIndex = 0;
    private final class_437 currentScreen;
    private final List<class_364> extendedControls = StringUtils.newArrayList();
    private final List<DynamicWidget> extendedWidgets = StringUtils.newArrayList();
    private final List<class_350<?>> extendedLists = StringUtils.newArrayList();
    private class_332 currentMatrix;
    private String title;
    private String subTitle;
    private class_437 parentScreen;
    private Phase currentPhase = Phase.PREINIT;
    private int screenX = 0;
    private int screenY = 0;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private float lastPartialTicks = 0.0f;
    private int lastMouseScroll = 0;
    private int contentHeight;
    private boolean canClose;
    private boolean isOverScreen;
    private boolean canModifyControls;

    public ExtendedScreen(class_437 parentScreen, String title, String subTitle) {
        super((class_2561)class_2561.method_43470((String)""));
        this.setGameInstance(ModUtils.getMinecraft());
        this.setParent(parentScreen);
        this.currentScreen = this;
        this.setScreenTitle(title);
        this.setScreenSubTitle(subTitle);
        this.setCanClose(true);
        this.setCanModifyControls(true);
        this.setContentHeight(0);
        this.setScreenSettings();
    }

    public ExtendedScreen(class_437 parentScreen, String title) {
        this(parentScreen, title, null);
    }

    public ExtendedScreen(class_437 parentScreen) {
        this(parentScreen, null);
    }

    public ExtendedScreen(String title, String subTitle) {
        this(null, title, subTitle);
    }

    public ExtendedScreen(String title) {
        this(title, null);
    }

    public ExtendedScreen() {
        this((class_437)null);
    }

    public static int getNextIndex() {
        return lastIndex++;
    }

    public static void resetIndex() {
        lastIndex = 0;
    }

    public static void copyToClipboard(class_310 instance, String input) {
        instance.field_1774.method_1455(StringUtils.normalize(input));
    }

    public static int getProtocol() {
        return ModUtils.MCProtocolID;
    }

    public static int getKeyByVersion(int lwjgl2Key, int lwjgl3Key) {
        return ExtendedScreen.getProtocol() > 340 ? lwjgl3Key : lwjgl2Key;
    }

    public static boolean isEscapeKey(int keyCode) {
        return keyCode == ExtendedScreen.getKeyByVersion(1, 256);
    }

    public static void enableRepeatEvents(class_310 instance, boolean enable) {
    }

    public void copyToClipboard(String input) {
        ExtendedScreen.copyToClipboard(this.getGameInstance(), input);
    }

    public void enableRepeatEvents(boolean enable) {
        ExtendedScreen.enableRepeatEvents(this.getGameInstance(), enable);
    }

    public void method_25426() {
        super.method_25426();
        this.clearData();
        this.enableRepeatEvents(true);
        this.currentPhase = Phase.INIT;
        this.initializeUi();
        this.currentPhase = Phase.READY;
    }

    public void clearData() {
        if (this.currentPhase != Phase.PREINIT) {
            this.currentPhase = Phase.PREINIT;
            this.setContentHeight(0);
            this.method_37067();
            this.extendedControls.clear();
            this.extendedWidgets.clear();
            this.extendedLists.clear();
        }
    }

    public void initializeUi() {
        if (this.currentPhase == Phase.PREINIT) {
            this.method_25426();
            return;
        }
        if (this.currentPhase == Phase.INIT) {
            this.resetMouseScroll();
            for (class_364 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.initializeUi();
            }
            this.refreshContentHeight();
        }
    }

    public void reloadUi() {
        this.method_25410(this.getGameInstance(), this.getScreenWidth(), this.getScreenHeight());
    }

    public void method_25410(@Nonnull class_310 mcIn, int w, int h) {
        if (this.isLoaded()) {
            for (class_364 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.method_25410(mcIn, w, h);
            }
        }
        super.method_25410(mcIn, w, h);
    }

    @Nonnull
    public <T extends class_364 & class_4068> T addControl(@Nonnull T buttonIn) {
        if (!this.canModifyControls()) {
            throw new IllegalStateException("Can't add control to control list");
        }
        if (buttonIn instanceof DynamicWidget) {
            DynamicWidget widget = (DynamicWidget)buttonIn;
            if (!this.extendedWidgets.contains(buttonIn)) {
                this.addWidget(widget);
            }
        }
        if (!this.method_25396().contains(buttonIn) && buttonIn instanceof ExtendedScreen) {
            super.method_25429(buttonIn);
        } else if (buttonIn instanceof class_4068) {
            this.method_37063(buttonIn);
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends class_350<?>> T addList(@Nonnull T buttonIn) {
        if (!this.canModifyControls()) {
            throw new IllegalStateException("Can't add control to control list");
        }
        if (buttonIn instanceof class_4068) {
            this.method_37063((class_364)buttonIn);
        }
        if (!this.extendedLists.contains(buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends DynamicWidget> T addWidget(@Nonnull T buttonIn) {
        if (!this.canModifyControls()) {
            throw new IllegalStateException("Can't add control to control list");
        }
        if (!this.extendedWidgets.contains(buttonIn)) {
            buttonIn.setControlPosY(this.getTop() + buttonIn.getTop());
            this.extendedWidgets.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        this.drawBackground(this.getLeft(), this.getRight(), this.getTop(), this.getBottom(), this.getOffset(), this.getTintFactor(), this.getScreenBackground());
    }

    public void drawBackground(double left, double right, double top, double bottom, double offset, float tintFactor, double u, double v, ScreenConstants.ColorData data) {
        tintFactor = MathUtils.clamp(tintFactor, 0.0f, 1.0f);
        Color startColor = StringUtils.offsetColor(data.startColor(), tintFactor);
        Color endColor = StringUtils.offsetColor(data.endColor(), tintFactor);
        if (StringUtils.isNullOrEmpty(data.texLocation())) {
            RenderUtils.drawGradient(left, right, top, bottom, data.colorLevel(), startColor, endColor);
        } else {
            Tuple<Boolean, String, class_2960> textureData = RenderUtils.getTextureData(this.getGameInstance(), data.texLocation());
            boolean usingExternalTexture = textureData.getFirst();
            class_2960 texLocation = textureData.getThird();
            this.drawTexture(left, right, top, bottom, data.texLevel(), data.useFullTexture(), usingExternalTexture, offset, u, v, data.textureWidth(), data.textureHeight(), startColor, endColor, texLocation);
        }
    }

    public void drawBackground(double left, double right, double top, double bottom, double offset, float tintFactor, ScreenConstants.ColorData data) {
        this.drawBackground(left, right, top, bottom, offset, tintFactor, left, top, data);
    }

    public void drawTexture(double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, boolean usingExternalTexture, double offset, double u, double v, double textureWidth, double textureHeight, Object startColorObj, Object endColorObj, class_2960 texLocation) {
        RenderUtils.drawTexture(this.getGameInstance(), left, right, top, bottom, zLevel, asFullTexture, usingExternalTexture, right - left, bottom - top, u, v + offset, textureWidth, textureHeight, startColorObj, endColorObj, texLocation);
    }

    public void drawTexture(double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, boolean usingExternalTexture, double offset, double u, double v, Object startColorObj, Object endColorObj, class_2960 texLocation) {
        this.drawTexture(left, right, top, bottom, zLevel, asFullTexture, usingExternalTexture, offset, u, v, 32.0, 32.0, startColorObj, endColorObj, texLocation);
    }

    public void drawTexture(double left, double right, double top, double bottom, double zLevel, boolean usingExternalTexture, double offset, double u, double v, Object startColorObj, Object endColorObj, class_2960 texLocation) {
        this.drawTexture(left, right, top, bottom, zLevel, true, usingExternalTexture, offset, u, v, startColorObj, endColorObj, texLocation);
    }

    public void drawTexture(double left, double right, double top, double bottom, boolean usingExternalTexture, double offset, double u, double v, Object startColorObj, Object endColorObj, class_2960 texLocation) {
        this.drawTexture(left, right, top, bottom, 0.0, usingExternalTexture, offset, u, v, startColorObj, endColorObj, texLocation);
    }

    public boolean hasWorld() {
        return WorldUtils.getWorld(this.getGameInstance()) != null;
    }

    public String getScreenTitle() {
        return this.title;
    }

    public void setScreenTitle(String title) {
        this.title = title;
    }

    public String getScreenSubTitle() {
        return this.subTitle;
    }

    public void setScreenSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public float getTintFactor() {
        return 1.0f;
    }

    public ScreenConstants.ColorData getScreenBackground() {
        return this instanceof ScrollPane ? (this.hasWorld() ? ScreenConstants.DEFAULT_ALT_WORLD_SCREEN_BACKGROUND : ScreenConstants.DEFAULT_ALT_SCREEN_BACKGROUND) : (this.hasWorld() ? ScreenConstants.DEFAULT_WORLD_SCREEN_BACKGROUND : ScreenConstants.DEFAULT_SCREEN_BACKGROUND);
    }

    public ScreenConstants.TooltipData getTooltipData(boolean isTooltip) {
        return isTooltip ? ScreenConstants.getDefaultTooltip() : ScreenConstants.getEmptyTooltip();
    }

    public ScreenConstants.TooltipData getTooltipData() {
        return this.getTooltipData(true);
    }

    public double getOffset() {
        return 0.0;
    }

    public void preRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.preDraw(this);
        }
    }

    public void renderExtra() {
        this.renderStringData();
        for (DynamicWidget widget : this.getWidgets()) {
            widget.draw(this);
        }
    }

    public void renderStringData() {
        this.renderTitles(this.getScreenTitle(), this.getScreenSubTitle());
    }

    public void renderTitles(String title, String subTitle) {
        boolean hasSubTitle;
        boolean hasMainTitle = !StringUtils.isNullOrEmpty(title);
        boolean bl = hasSubTitle = !StringUtils.isNullOrEmpty(subTitle);
        if (hasMainTitle) {
            if (hasSubTitle) {
                this.renderScrollingString(title, 30, 2, this.getScreenWidth() - 30, 16, 0xFFFFFF);
                this.renderScrollingString(subTitle, 30, 16, this.getScreenWidth() - 30, 30, 0xFFFFFF);
            } else {
                this.renderScrollingString(title, 30, 0, this.getScreenWidth() - 30, 32, 0xFFFFFF);
            }
        }
    }

    public void postRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.postDraw(this);
        }
    }

    public void method_57736(@Nonnull class_332 matrixStack, int posX, int posY, int mouseX, int mouseY) {
        this.renderCriticalData();
    }

    public void method_25394(@Nonnull class_332 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentMatrix = matrixStack;
        if (this.isLoaded()) {
            this.preRender();
            RenderUtils.enableScissor(matrixStack, this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
            super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.lastPartialTicks = partialTicks;
            this.isOverScreen = RenderUtils.isMouseOver((double)mouseX, (double)mouseY, this);
            this.renderExtra();
            RenderUtils.disableScissor(matrixStack);
            for (class_364 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.method_25394(matrixStack, mouseX, mouseY, partialTicks);
            }
            this.postRender();
        }
    }

    public boolean method_25405(double d, double e) {
        return super.method_25405(d, e) && this.isLoaded() && this.isOverScreen;
    }

    public boolean method_25403(double mX, double mY, int mouseButton, double dragX, double dragY) {
        if (this.isLoaded()) {
            for (class_350<?> listControl : this.getLists()) {
                if (!listControl.method_25403(mX, mY, mouseButton, dragX, dragY)) continue;
                return true;
            }
            for (class_364 extendedControl : this.getControls()) {
                ExtendedScreen extendedScreen;
                if (!(extendedControl instanceof ExtendedScreen) || !(extendedScreen = (ExtendedScreen)extendedControl).method_25403(mX, mY, mouseButton, dragX, dragY)) continue;
                return true;
            }
            return super.method_25403(mX, mY, mouseButton, dragX, dragY);
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.isLoaded()) {
            this.setMouseScroll((int)deltaY);
            for (class_350<?> listControl : this.getLists()) {
                if (!listControl.method_25401(mouseX, mouseY, deltaX, deltaY)) continue;
                return true;
            }
            for (class_364 extendedControl : this.getControls()) {
                ExtendedScreen extendedScreen;
                if (!(extendedControl instanceof ExtendedScreen) || !(extendedScreen = (ExtendedScreen)extendedControl).method_25401(mouseX, mouseY, deltaX, deltaY)) continue;
                return true;
            }
            return super.method_25401(mouseX, mouseY, deltaX, deltaY);
        }
        return false;
    }

    public boolean method_25404(int keyCode, int mouseX, int mouseY) {
        if (this.isLoaded()) {
            if (this.isCurrentScreen()) {
                if (ExtendedScreen.isEscapeKey(keyCode) && this.canClose()) {
                    this.openScreen(this.getParent());
                    return true;
                }
                return super.method_25404(keyCode, mouseX, mouseY);
            }
            if (this.method_25399() != null) {
                return this.method_25399().method_25404(keyCode, mouseX, mouseY);
            }
        }
        return false;
    }

    public void method_25393() {
        if (this.isLoaded()) {
            for (class_364 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.method_25393();
            }
            super.method_25393();
        }
    }

    public boolean method_25422() {
        return false;
    }

    public void method_25432() {
        if (this.isLoaded()) {
            for (class_364 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.method_25432();
            }
            this.clearData();
            ExtendedScreen.resetIndex();
            this.enableRepeatEvents(false);
        }
    }

    @Nonnull
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37056(@Nonnull class_6382 arg) {
    }

    public class_310 getGameInstance() {
        return this.field_22787;
    }

    public void setGameInstance(class_310 instance) {
        this.field_22787 = instance;
    }

    public void openScreen(class_437 targetScreen) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen);
    }

    public void openScreen(ExtendedScreen targetScreen, class_437 parentScreen, boolean setParent) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen, parentScreen, setParent);
    }

    public void openScreen(ExtendedScreen targetScreen, class_437 parentScreen) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen, parentScreen);
    }

    public void openScreen(ExtendedScreen targetScreen) {
        this.openScreen(targetScreen, this.getInstance());
    }

    public int computeGuiScale() {
        return RenderUtils.computeGuiScale(this.getGameInstance());
    }

    public int getButtonY(int order) {
        int topPosition = this.getTop();
        class_437 class_4372 = this.getInstance();
        if (class_4372 instanceof ScrollPane) {
            ScrollPane pane = (ScrollPane)class_4372;
            topPosition += pane.getPadding();
        }
        return topPosition + 5 * (order + 1) + 20 * order;
    }

    public int getButtonY(int order, int offset, boolean appendByOrder) {
        return this.getButtonY(order) + offset * (appendByOrder ? order : 1);
    }

    public int getButtonY(int order, int offset) {
        return this.getButtonY(order, offset, false);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, boolean isCentered, boolean isTooltip, ScreenConstants.TooltipData colorInfo) {
        RenderUtils.drawMultiLineString(this.getGameInstance(), this.getCurrentMatrix(), textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, this.getFontRenderer(), isCentered, isTooltip, colorInfo);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, boolean isCentered, boolean isTooltip) {
        this.drawMultiLineString(textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, isCentered, isTooltip, this.getTooltipData(isTooltip));
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth) {
        this.drawMultiLineString(textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, false, true);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY) {
        this.drawMultiLineString(textToInput, posX, posY, this.getScreenWidth(), this.getScreenHeight(), this.getWrapWidth());
    }

    public void drawMultiLineString(List<String> textToInput) {
        this.drawMultiLineString(textToInput, this.getMouseX(), this.getMouseY());
    }

    public void renderScrollingString(String message, float centerX, float minX, float minY, float maxX, float maxY, int color) {
        RenderUtils.renderScrollingString(this.getCurrentMatrix(), this.getGameInstance(), this.getFontRenderer(), message, centerX, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        RenderUtils.renderScrollingString(this.getCurrentMatrix(), this.getGameInstance(), this.getFontRenderer(), message, centerX, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, float minX, float minY, float maxX, float maxY, int color) {
        this.renderScrollingString(message, maxX - (maxX - minX) / 2.0f, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, int minX, int minY, int maxX, int maxY, int color) {
        this.renderScrollingString(message, maxX - (maxX - minX) / 2, minX, minY, maxX, maxY, color);
    }

    public void renderCenteredString(String text, float xPos, float yPos, int color) {
        RenderUtils.renderCenteredString(this.getCurrentMatrix(), this.getFontRenderer(), text, xPos, yPos, color);
    }

    public void renderCenteredString(String text, int xPos, int yPos, int color) {
        RenderUtils.renderCenteredString(this.getCurrentMatrix(), this.getFontRenderer(), text, xPos, yPos, color);
    }

    public void renderCenteredString(String text, float yPos, int color) {
        this.renderCenteredString(text, (float)this.getScreenWidth() / 2.0f, yPos, color);
    }

    public void renderCenteredString(String text, int yPos, int color) {
        this.renderCenteredString(text, this.getScreenWidth() / 2, yPos, color);
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        RenderUtils.renderString(this.getCurrentMatrix(), this.getFontRenderer(), text, xPos, yPos, color);
    }

    public void renderString(String text, int xPos, int yPos, int color) {
        this.renderString(text, (float)xPos, (float)yPos, color);
    }

    public int getStringWidth(String string) {
        return RenderUtils.getStringWidth(this.getFontRenderer(), string);
    }

    public List<String> createRenderLines(List<String> original, int wrapWidth) {
        List<String> data = StringUtils.newArrayList();
        for (String line : original) {
            data.addAll(RenderUtils.listFormattedStringToWidth(this.getFontRenderer(), line, wrapWidth));
        }
        return data;
    }

    public List<String> createRenderLines(String original, int wrapWidth) {
        return this.createRenderLines(StringUtils.splitTextByNewLine(original, true), wrapWidth);
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public float getPartialTicks() {
        return this.lastPartialTicks;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public void setScreenX(int screenX) {
        this.screenX = screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public void setScreenY(int screenY) {
        this.screenY = screenY;
    }

    public boolean isOverScreen() {
        return this.isOverScreen;
    }

    public boolean isCurrentScreen() {
        return GameUtils.getCurrentScreen(this.getGameInstance()) == this;
    }

    public int getMouseScroll() {
        return this.lastMouseScroll;
    }

    public void setMouseScroll(int mouseScroll) {
        this.lastMouseScroll = mouseScroll;
    }

    public void resetMouseScroll() {
        this.setMouseScroll(0);
    }

    public int getMaxWidth() {
        return this.getScreenWidth();
    }

    public void setScreenSettings() {
    }

    public int getScreenWidth() {
        return this.field_22789;
    }

    public void setScreenWidth(int screenWidth) {
        this.field_22789 = screenWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
    }

    public void refreshContentHeight() {
        this.setContentHeight(0);
        for (DynamicWidget widget : this.getWidgets()) {
            int widgetHeight = widget.getBottom();
            if (widgetHeight <= this.getContentHeight()) continue;
            this.setContentHeight(widgetHeight);
        }
    }

    public int getScreenHeight() {
        return this.field_22790;
    }

    public void setScreenHeight(int screenHeight) {
        this.field_22790 = screenHeight;
    }

    public class_327 getFontRenderer() {
        return StringUtils.getOrDefault(this.getGameInstance().field_1772, RenderUtils.getDefaultFontRenderer());
    }

    public int getFontHeight() {
        return RenderUtils.getFontHeight(this.getFontRenderer());
    }

    public int getLeft() {
        return this.getScreenX();
    }

    public int getRight() {
        return this.getScreenX() + this.getScreenWidth();
    }

    public int getBottom() {
        return this.getScreenY() + this.getScreenHeight();
    }

    public int getTop() {
        return this.getScreenY();
    }

    public class_332 getCurrentMatrix() {
        return this.currentMatrix;
    }

    public class_437 getInstance() {
        return this.currentScreen;
    }

    public class_437 getParent() {
        return this.parentScreen;
    }

    public void setParent(class_437 parentScreen) {
        this.parentScreen = parentScreen;
    }

    public boolean canClose() {
        return this.canClose;
    }

    public void setCanClose(boolean canClose) {
        this.canClose = canClose;
    }

    public boolean canModifyControls() {
        return this.canModifyControls;
    }

    public void setCanModifyControls(boolean canModifyControls) {
        this.canModifyControls = canModifyControls;
    }

    public List<class_364> getControls() {
        return StringUtils.newArrayList(this.extendedControls);
    }

    public List<DynamicWidget> getWidgets() {
        return StringUtils.newArrayList(this.extendedWidgets);
    }

    public List<class_350<?>> getLists() {
        return StringUtils.newArrayList(this.extendedLists);
    }

    public boolean isLoaded() {
        return this.currentPhase == Phase.READY;
    }

    public static enum Phase {
        PREINIT,
        INIT,
        READY;

    }
}

